/******************************************************************
 *FILE: atmel_mxt_i2c.h
 *SW-COMPONENT: QNX atmel touch driver
 *DESCRIPTION: This is header file for i2c communications.
 *COPYRIGHT: © 2019 Robert Bosch GmbH
 *
 *This program is free software; you can redistribute  it and/or modify it
 *under  the terms of  the GNU General  Public License as published by the
 *Free Software Foundation;  either version 2 of the  License, or (at your
 *option) any later version.
 ******************************************************************/
#ifndef ATMEL_MXT_I2C_H_
#define ATMEL_MXT_I2C_H_

#ifdef  __cplusplus
extern "C" {
#endif

#include <stdint.h>

int mxt_i2c_open(char* i2c_devname, unsigned slave_id, unsigned i2c_speed);
void mxt_i2c_close(int fd);
int mxt_read_reg(int fd, uint16_t reg, unsigned len, void* buf);
int mxt_write_reg(int fd, uint16_t reg, uint16_t len, const void *val);

typedef struct {
	int (*open)(char* i2c_devname, unsigned slave_id, unsigned i2c_speed);
	void (*close)(int fd);
	int (*read_reg)(int fd, uint16_t reg, unsigned len, void* buf);
	int (*write_reg)(int fd, uint16_t reg, uint16_t len, const void *val);
} atmel_libi2c_funcs_t;

void get_atmel_libi2c_funcs(atmel_libi2c_funcs_t* funcs);

#ifdef  __cplusplus
}
#endif

#endif /* ATMEL_MXT_I2C_H_ */
